unit MAIN;

//       
//    ,      
//  .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  Service1, ExtCtrls, Buttons;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Label2: TLabel;
    Image1: TImage;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    Bevel1: TBevel;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Timer1: TTimer;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

var IQueue  : TIQueue;  //   
    RunFlag : boolean;  //   

// 
procedure TForm1.FormCreate(Sender: TObject);
begin
   RunFlag := False;
   Randomize;
end;

//     
procedure TForm1.FormDestroy(Sender: TObject);
begin
  RunFlag := False;
  if Assigned(IQueue) then IQueue.Free;
end;

// 
procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  if SpeedButton1.Down
  then begin
     //   
     if not Assigned(IQueue) then IQueue := TIQueue.Create(Memo1);
  end;
  if SpeedButton2.Down
  then begin
     //   
     if not Assigned(IQueue) then IQueue := TDisplay.Create(Image1);
  end;
  SpeedButton1.Enabled := False;    //   
  SpeedButton2.Enabled := False;    //   
  RunFlag := True;                  //  
end;

// 
procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  if Assigned(IQueue)
  then begin
     RunFlag := False;              //  
     IQueue.Free;                   //  
     IQueue := nil;
     SpeedButton1.Enabled := True;  //   
     SpeedButton2.Enabled := True;  //   
  end;
end;

//  
procedure TForm1.Timer1Timer(Sender: TObject);
begin
  if RunFlag
  then begin
     //      
     IQueue.AddItemToTail(Random(Image1.Height - 1));
     IQueue.ShowItemQueue();
  end;
end;

end.
